#include "StdAfx.h"
#include "Coordinate.h"

// CSize
inline CwSize::CwSize() throw()
{ /* random filled */ }
inline CwSize::CwSize(int initCX, int initCY) throw()
{ cx = initCX; cy = initCY; }
inline CwSize::CwSize(sSize initSize) throw()
{ *(sSize*)this = initSize; }
inline CwSize::CwSize(sPoint initPt) throw()
{ *(sPoint*)this = initPt; }
inline CwSize::CwSize(UINT dwSize) throw()
{
	cx = (short)LOWORD(dwSize);
	cy = (short)HIWORD(dwSize);
}
inline bool CwSize::operator==(sSize size) const throw()
{ return (cx == size.cx && cy == size.cy); }
inline bool CwSize::operator!=(sSize size) const throw()
{ return (cx != size.cx || cy != size.cy); }
inline void CwSize::operator+=(sSize size) throw()
{ cx += size.cx; cy += size.cy; }
inline void CwSize::operator-=(sSize size) throw()
{ cx -= size.cx; cy -= size.cy; }
inline void CwSize::SetSize(int CX, int CY) throw()
{ cx = CX; cy = CY; }	
inline CwSize CwSize::operator+(sSize size) const throw()
{ return CwSize(cx + size.cx, cy + size.cy); }
inline CwSize CwSize::operator-(sSize size) const throw()
{ return CwSize(cx - size.cx, cy - size.cy); }
inline CwSize CwSize::operator-() const throw()
{ return CwSize(-cx, -cy); }
inline CwPoint CwSize::operator+(sPoint point) const throw()
{ return CwPoint(cx + point.x, cy + point.y); }
inline CwPoint CwSize::operator-(sPoint point) const throw()
{ return CwPoint(cx - point.x, cy - point.y); }
inline CwRect CwSize::operator+(const sRect* lpRect) const throw()
{ return CwRect(lpRect) + *this; }
inline CwRect CwSize::operator-(const sRect* lpRect) const throw()
{ return CwRect(lpRect) - *this; }

// CPoint
inline CwPoint::CwPoint() throw()
{ /* random filled */ }
inline CwPoint::CwPoint(int initX, int initY) throw()
{ x = initX; y = initY; }
inline CwPoint::CwPoint(sPoint initPt) throw()
{ *(sPoint*)this = initPt; }
inline CwPoint::CwPoint(sSize initSize) throw()
{ *(sSize*)this = initSize; }
inline CwPoint::CwPoint(LPARAM dwPoint) throw()
{
	x = (short)GET_X_LPARAM(dwPoint);
	y = (short)GET_Y_LPARAM(dwPoint);
}
inline void CwPoint::Offset(int xOffset, int yOffset) throw()
{ x += xOffset; y += yOffset; }
inline void CwPoint::Offset(sPoint point) throw()
{ x += point.x; y += point.y; }
inline void CwPoint::Offset(sSize size) throw()
{ x += size.cx; y += size.cy; }
inline void CwPoint::SetPoint(int X, int Y) throw()
{ x = X; y = Y; }
inline bool CwPoint::operator==(sPoint point) const throw()
{ return (x == point.x && y == point.y); }
inline bool CwPoint::operator!=(sPoint point) const throw()
{ return (x != point.x || y != point.y); }
inline void CwPoint::operator+=(sSize size) throw()
{ x += size.cx; y += size.cy; }
inline void CwPoint::operator-=(sSize size) throw()
{ x -= size.cx; y -= size.cy; }
inline void CwPoint::operator+=(sPoint point) throw()
{ x += point.x; y += point.y; }
inline void CwPoint::operator-=(sPoint point) throw()
{ x -= point.x; y -= point.y; }
inline CwPoint CwPoint::operator+(sSize size) const throw()
{ return CwPoint(x + size.cx, y + size.cy); }
inline CwPoint CwPoint::operator-(sSize size) const throw()
{ return CwPoint(x - size.cx, y - size.cy); }
inline CwPoint CwPoint::operator-() const throw()
{ return CwPoint(-x, -y); }
inline CwPoint CwPoint::operator+(sPoint point) const throw()
{ return CwPoint(x + point.x, y + point.y); }
inline CwSize CwPoint::operator-(sPoint point) const throw()
{ return CwSize(x - point.x, y - point.y); }
inline CwRect CwPoint::operator+(const sRect* lpRect) const throw()
{ return CwRect(lpRect) + *this; }
inline CwRect CwPoint::operator-(const sRect* lpRect) const throw()
{ return CwRect(lpRect) - *this; }

// CRect
inline CwRect::CwRect() throw()
{ /* random filled */ }
inline CwRect::CwRect(int l, int t, int r, int b) throw()
{ left = l; top = t; right = r; bottom = b; }
inline CwRect::CwRect(const sRect& srcRect) throw()
{ *this = srcRect; }
inline CwRect::CwRect(LPCRect lpSrcRect) throw()
{ *this = *lpSrcRect; }
inline CwRect::CwRect(sPoint point, sSize size) throw()
{ right = (left = point.x) + size.cx; bottom = (top = point.y) + size.cy; }
inline CwRect::CwRect(sPoint topLeft, sPoint bottomRight) throw()
{ left = topLeft.x; top = topLeft.y;
right = bottomRight.x; bottom = bottomRight.y; }
inline int CwRect::Width() const throw()
{ return right - left; }
inline int CwRect::Height() const throw()
{ return bottom - top; }
inline CwSize CwRect::Size() const throw()
{ return CwSize(right - left, bottom - top); }
inline CwPoint& CwRect::TopLeft() throw()
{ return *((CwPoint*)this); }
inline CwPoint& CwRect::BottomRight() throw()
{ return *((CwPoint*)this+1); }
inline const CwPoint& CwRect::TopLeft() const throw()
{ return *((CwPoint*)this); }
inline const CwPoint& CwRect::BottomRight() const throw()
{ return *((CwPoint*)this+1); }
inline CwPoint CwRect::CenterPoint() const throw()
{ return CwPoint((left+right)/2, (top+bottom)/2); }
inline void CwRect::SwapLeftRight() throw()
{ SwapLeftRight(LPRect(this)); }
inline void CwRect::SwapLeftRight(LPRect lpRect) throw()
{ LONG temp = lpRect->left; lpRect->left = lpRect->right; lpRect->right = temp; }
inline CwRect::operator LPRect() throw()
{ return this; }
inline CwRect::operator LPCRect() const throw()
{ return this; }
inline bool CwRect::IsRectEmpty() const throw()
{ return (left == right) || (top == bottom); }
inline bool CwRect::IsRectNull() const throw()
{ return (left == 0 && right == 0 && top == 0 && bottom == 0); }
inline bool CwRect::PtInRect(sPoint point) const throw()
{ return (left <= point.x) && (right >= point.x) && (top <= point.y) && (bottom >= point.y); }
inline void CwRect::SetRect(int x1, int y1, int x2, int y2) throw()
{ left = x1; top = y1; right = x2; bottom = y2; }
inline void CwRect::SetRect(sPoint topLeft, sPoint bottomRight) throw()
{ SetRect(topLeft.x, topLeft.y, bottomRight.x, bottomRight.y); }
inline void CwRect::SetRectEmpty() throw()
{ left = top = right = bottom = 0; }
inline void CwRect::CopyRect(LPCRect lpSrcRect) throw()
{
	this->left	= lpSrcRect->left;
	this->top	= lpSrcRect->top;
	this->right = lpSrcRect->right;
	this->bottom= lpSrcRect->bottom;
}
inline bool CwRect::EqualRect(LPCRect lpRect) const throw()
{ return (left == lpRect->left) && (top == lpRect->top) && (right == lpRect->right) && (bottom == lpRect->bottom); }
// inline void sRect::InflateRect(int x, int y) throw()
// { ::InflateRect(this, x, y); }
// inline void sRect::InflateRect(SIZE size) throw()
// { ::InflateRect(this, size.cx, size.cy); }
// inline void sRect::DeflateRect(int x, int y) throw()
// { ::InflateRect(this, -x, -y); }
// inline void sRect::DeflateRect(SIZE size) throw()
// { ::InflateRect(this, -size.cx, -size.cy); }
inline void CwRect::OffsetRect(int x, int y) throw()
{ bottom = Height() + y; top = y;  right = Width() + x; left = x; }
inline void CwRect::OffsetRect(sPoint point) throw()
{ bottom = Height() + point.y; top = point.y;  right = Width() + point.x; left = point.x; }
inline void CwRect::OffsetRect(sSize size) throw()
{ bottom = Height() + size.cy; top = size.cy;  right = Width() + size.cx; left = size.cx; }
inline void CwRect::MoveToY(int y) throw()
{ bottom = Height() + y; top = y; }
inline void CwRect::MoveToX(int x) throw()
{ right = Width() + x; left = x; }
inline void CwRect::MoveToXY(int x, int y) throw()
{ MoveToX(x); MoveToY(y); }
inline void CwRect::MoveToXY(sPoint pt) throw()
{ MoveToX(pt.x); MoveToY(pt.y); }
// inline bool sRect::IntersectRect(LPCRect lpRect1, LPCRect lpRect2) throw()
// { return ::IntersectRect(this, lpRect1, lpRect2);}
// inline bool sRect::UnionRect(LPCRect lpRect1, LPCRect lpRect2) throw()
// { return ::UnionRect(this, lpRect1, lpRect2); }
inline void CwRect::operator=(const sRect& srcRect) throw()
{ CopyRect(&srcRect); }
inline bool CwRect::operator==(const sRect& rect) const throw()
{ return EqualRect(&rect); }
inline bool CwRect::operator!=(const sRect& rect) const throw()
{ return !EqualRect(&rect); }
inline void CwRect::operator+=(sPoint point) throw()
{ OffsetRect(point.x, point.y); }
inline void CwRect::operator+=(sSize size) throw()
{ OffsetRect(size.cx, size.cy); }
inline void CwRect::operator+=(LPCRect lpRect) throw()
{ InflateRect(lpRect); }
inline void CwRect::operator-=(sPoint point) throw()
{ OffsetRect(-point.x, -point.y); }
inline void CwRect::operator-=(sSize size) throw()
{ OffsetRect(-size.cx, -size.cy); }
inline void CwRect::operator-=(LPCRect lpRect) throw()
{ DeflateRect(lpRect); }
// inline void sRect::operator&=(const Rect& rect) throw()
// { IntersectRect(this, this, &rect); }
// inline void sRect::operator|=(const Rect& rect) throw()
// { ::UnionRect(this, this, &rect); }
inline CwRect CwRect::operator+(sPoint pt) const throw()
{ CwRect rect(*this); rect.OffsetRect(pt.x, pt.y); return rect; }
inline CwRect CwRect::operator-(sPoint pt) const throw()
{ CwRect rect(*this); rect.OffsetRect(-pt.x, -pt.y); return rect; }
inline CwRect CwRect::operator+(sSize size) const throw()
{ CwRect rect(*this); rect.OffsetRect(size.cx, size.cy); return rect; }
inline CwRect CwRect::operator-(sSize size) const throw()
{ CwRect rect(*this); rect.OffsetRect(-size.cx, -size.cy); return rect; }
inline CwRect CwRect::operator+(LPCRect lpRect) const throw()
{ CwRect rect(this); rect.InflateRect(lpRect); return rect; }
inline CwRect CwRect::operator-(LPCRect lpRect) const throw()
{ CwRect rect(this); rect.DeflateRect(lpRect); return rect; }
// inline sRect sRect::operator&(const Rect& rect2) const throw()
// { sRect rect; ::IntersectRect(&rect, this, &rect2);	return rect; }
// inline sRect sRect::operator|(const Rect& rect2) const throw()
// { sRect rect; ::UnionRect(&rect, this, &rect2);	return rect; }
// inline bool sRect::SubtractRect(LPCRect lpRectSrc1, LPCRect lpRectSrc2) throw()
// { return ::SubtractRect(this, lpRectSrc1, lpRectSrc2); }

inline void CwRect::NormalizeRect() throw()
{
	int nTemp;
	if (left > right)
	{
		nTemp = left;
		left = right;
		right = nTemp;
	}
	if (top > bottom)
	{
		nTemp = top;
		top = bottom;
		bottom = nTemp;
	}
}

inline void CwRect::InflateRect(LPCRect lpRect) throw()
{
	left -= lpRect->left;		top -= lpRect->top;
	right += lpRect->right;		bottom += lpRect->bottom;
}

inline void CwRect::InflateRect(int l, int t, int r, int b) throw()
{
	left -= l;			top -= t;
	right += r;			bottom += b;
}

inline void CwRect::DeflateRect(LPCRect lpRect) throw()
{
	left += lpRect->left;	top += lpRect->top;
	right -= lpRect->right;	bottom -= lpRect->bottom;
}

inline void CwRect::DeflateRect(int l, int t, int r, int b) throw()
{
	left += l;		top += t;
	right -= r;		bottom -= b;
}

//inline CwRect CwRect::MulDiv(int nMultiplier, int nDivisor) const throw()
//{
//	return CwRect(
//		::MulDiv(left, nMultiplier, nDivisor),
//		::MulDiv(top, nMultiplier, nDivisor),
//		::MulDiv(right, nMultiplier, nDivisor),
//		::MulDiv(bottom, nMultiplier, nDivisor));
//}